####################################################
### code chunk number : Simulations: Marginal pmf, alpha = 2, beta = 1
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 2             ## hyperparameter
beta = 1              ## hyperparameter     

x = seq(0, 10, by = 1)
md = Marginal_density_alpha_beta(x, alpha, beta)

dev.new()
col = 1:1
pch = 1:1
lty = 1:1
xlim = range(x); xlim
# ylim = c(0, 0.8); ylim
plot(x, md, type = "n", xlim = xlim, xlab = expression(x), ylab = "Marginal pmf")
points(x, md,  pch = pch[1], col = col[1], lwd = 4)
lines(x, md,   lty = lty[1], col = col[1], lwd = 4)
# title(Title)
leg.txt = expression(paste(alpha, " = 2, ", beta, " = 1"))
legend("topright", legend = leg.txt, col = col, pch = pch, lty = lty, lwd = 2)
# savePlot(filename = paste("figure/md_x", sep=""), type = c("pdf"))


####################################################
### code chunk number : Simulations: Marginal pmf, alpha changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = c(1, 2, 4, 8)  ## hyperparameter
beta = 1               ## hyperparameter

x = seq(0, 10, by = 1)
md1 = Marginal_density_alpha_beta(x, alpha = alpha[1], beta)
md2 = Marginal_density_alpha_beta(x, alpha = alpha[2], beta)
md3 = Marginal_density_alpha_beta(x, alpha = alpha[3], beta)
md4 = Marginal_density_alpha_beta(x, alpha = alpha[4], beta)
sum(md1)
sum(md2)
sum(md3)
sum(md4)
c(sum(md1), sum(md2), sum(md3), sum(md4))

dev.new()
col = c("red", "blue", "purple", "black")
pch = 1:4
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal pmf")
points(x, md1,  pch = pch[1], col = col[1], lwd = 4)
points(x, md2,  pch = pch[2], col = col[2], lwd = 4)
points(x, md3,  pch = pch[3], col = col[3], lwd = 4)
points(x, md4,  pch = pch[4], col = col[4], lwd = 4)
lines(x, md1,   lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,   lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,   lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,   lty = lty[4], col = col[4], lwd = 4)
leg.txt = c(
expression(paste(alpha, " = 1", sep = "")),
expression(paste(alpha, " = 2", sep = "")),
expression(paste(alpha, " = 4", sep = "")),
expression(paste(alpha, " = 8", sep = ""))
)
legend("topright", legend = leg.txt, col = col, pch = pch, lty = lty, lwd = 2)
savePlot(filename = paste("figure/P-G_md_x_alpha_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/P-G_md_x_alpha_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal pmf, beta changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 2              ## hyperparameter
beta = c(0.5, 1, 2, 4) ## hyperparameter

x = seq(0, 10, by = 1)
md1 = Marginal_density_alpha_beta(x, alpha, beta = beta[1])
md2 = Marginal_density_alpha_beta(x, alpha, beta = beta[2])
md3 = Marginal_density_alpha_beta(x, alpha, beta = beta[3])
md4 = Marginal_density_alpha_beta(x, alpha, beta = beta[4])
sum(md1)
sum(md2)
sum(md3)
sum(md4)
c(sum(md1), sum(md2), sum(md3), sum(md4))

dev.new()
col = c("red", "blue", "purple", "black")
pch = 1:4
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal pmf")
points(x, md1,  pch = pch[1], col = col[1], lwd = 4)
points(x, md2,  pch = pch[2], col = col[2], lwd = 4)
points(x, md3,  pch = pch[3], col = col[3], lwd = 4)
points(x, md4,  pch = pch[4], col = col[4], lwd = 4)
lines(x, md1,   lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,   lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,   lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,   lty = lty[4], col = col[4], lwd = 4)
leg.txt = c(
expression(paste(beta, " = 0.5", sep = "")),
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 2", sep = "")),
expression(paste(beta, " = 4", sep = ""))
)
legend("topright", legend = leg.txt, col = col, pch = pch, lty = lty, lwd = 2)
savePlot(filename = paste("figure/P-G_md_x_beta_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/P-G_md_x_beta_changes", sep=""), type = c("jpg"))

